// Copyright (c) Microsoft Corporation. All rights reserved.

// Called by PREPROCESS_FUNCTION in VC7\VCProjects\ATLWiz.vsz
function CheckATLProjectName(selProj, selObj)
{
	var strProjectName = wizard.FindSymbol("PROJECT_NAME");
	if (strProjectName.toLowerCase() == "compreg")
	{
		var L_NameNotAllowed_Text = "This project name is not allowed. Please chose another one."
		wizard.ReportError(L_NameNotAllowed_Text);
		return false;
	}
	return true;
}

function OnFinish(selProj, selObj)
{
	try
	{
		var strTemplatePath	= wizard.FindSymbol("TEMPLATES_PATH");
		var strProjectPath	= wizard.FindSymbol("PROJECT_PATH");
		var strProjectName	= wizard.FindSymbol("PROJECT_NAME");

		wizard.AddSymbol("RC_FILE_NAME",CreateSafeRCFileName(strProjectName)+".rc");
		wizard.AddSymbol("SAFE_PROJECT_APPID_NAME", wizard.FindSymbol("SAFE_PROJECT_IDENTIFIER_NAME"));
		wizard.AddSymbol("SAFE_IDL_NAME", CreateASCIIName(wizard.FindSymbol("PROJECT_NAME")));
		selProj = CreateProject(strProjectName, strProjectPath);

		AddConfigurations(selProj, strProjectName);

		SetupFilters(selProj);
		selProj.Object.keyword = "AtlProj";

		AddFilesToProjectWithInfFile(selProj, strProjectName);

		var L_strGenerated_Text = "ɵļ";
		var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");

		var strMIDLHeader = strProjectPath + "\\" + strIdlName + "_i.h";
		wizard.RenderTemplate(strTemplatePath + "\\root_i.h", strMIDLHeader, true);

		var strMIDL_IFile = strProjectPath + "\\" + strIdlName + "_i.c";
		wizard.RenderTemplate(strTemplatePath + "\\root_i.c", strMIDL_IFile, true);

		var oGeneratedFiles = selProj.Object.AddFilter(L_strGenerated_Text);
		if (oGeneratedFiles)
		{
			oGeneratedFiles.SourceControlFiles = false;
			oGeneratedFiles.AddFile(strMIDLHeader);
			oGeneratedFiles.AddFile(strMIDL_IFile);
		}
		else
		{
			selProj.Object.AddFile(strMIDLHeader);
			selProj.Object.AddFile(strMIDL_IFile);
		}

		if (!wizard.FindSymbol("GENERATE_ATL_DOCUMENT"))
		{
			// Add existing items (links) from MFC project handlers are being added for.
			// Add the document h/cpp, view h.cpp, and cntritem h/cpp (if exist).
			oFSO = new ActiveXObject("Scripting.FileSystemObject");

			var strMFCDocHeader = wizard.FindSymbol("DOCUMENT_HEADER_FILENAME_TRIMMED");
			if (strMFCDocHeader != "")
			{
				var strFile;

				strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCDocHeader);
				if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCDocHeader))
				{
					selProj.Object.AddFile(strMFCDocHeader);
				}

				var strMFCDocImpl = strMFCDocHeader.substring(0, strMFCDocHeader.length - 1) + "cpp";
				strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCDocImpl);
				if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCDocImpl))
				{
					selProj.Object.AddFile(strMFCDocImpl);
				}

				var strMFCViewHeader = wizard.FindSymbol("VIEW_HEADER_FILENAME_TRIMMED");
				if (strMFCViewHeader != "")
				{
					strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCViewHeader);
					if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCViewHeader))
					{
						selProj.Object.AddFile(strMFCViewHeader);
					}

					var strMFCViewImpl = strMFCViewHeader.substring(0, strMFCViewHeader.length - 1) + "cpp";
					strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCViewImpl);
					if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCViewImpl))
					{
						selProj.Object.AddFile(strMFCViewImpl);
					}
				}

				var nLength = strMFCDocHeader.length;
				var nEndIndex = nLength - 1;
				while (nEndIndex > 0 && (strMFCDocHeader.charAt(nEndIndex) != '\\'))
				{
					nEndIndex--;
				}

				var strMFCCntrHeader = strMFCDocHeader.substring(0, nEndIndex + 1) + "CntrItem.h";
				strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCCntrHeader);
				if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCCntrHeader))
				{
					selProj.Object.AddFile(strMFCCntrHeader);

					var strMFCCntrImpl = strMFCDocHeader.substring(0, nEndIndex + 1) + "CntrItem.cpp";
					strFile = oFSO.GetAbsolutePathName(strProjectPath + "\\" + strMFCCntrImpl);
					if (oFSO.FileExists(strFile) && selProj.Object.CanAddFile(strMFCCntrImpl))
					{
						selProj.Object.AddFile(strMFCCntrImpl);
					}
				}
			}
		}

		// Set special flags on the MIDL-generated .c file
		var projfile = selProj.Object.Files(strIdlName + "_i.c");
		if (projfile != null) {
			projfile = projfile.Object;
			SetFileProperties(projfile, strIdlName + "_i.c");
		}

		SetPchSettings(selProj, strProjectName);

		var Sdl = wizard.FindSymbol("SDL_CHECK");

		if (Sdl) 
		{
			EnableSDLCheckSettings(selProj);
		}

		selProj.Object.Save();

		var bMergeProxy = wizard.FindSymbol("MERGE_PROXY_STUB");
		if (!bMergeProxy)
		{
			var strDefFile = strProjectPath + "\\" + strProjectName + "ps.def";
			var str_PFile;
			var str_IFile;

			str_PFile = strProjectPath + "\\" + strIdlName + "_p.c";
			str_IFile = strProjectPath + "\\" + strIdlName + "_i.c";

			strProjectName += "PS";
			wizard.AddSymbol("CLOSE_SOLUTION", false);
			var oPSProj = CreateProject(strProjectName, strProjectPath);

			SetPSConfigurations(oPSProj, selProj);

			var strSrcFilter = wizard.FindSymbol("SOURCE_FILTER");
			var L_Source_Text = "Դļ";
			var group = oPSProj.Object.AddFilter(L_Source_Text);
			group.Filter = strSrcFilter;

			oPSProj.Object.keyword = "AtlPSProj";

			wizard.RenderTemplate(strTemplatePath + "\\rootps.def", strDefFile);
			oPSProj.Object.AddFile(strDefFile);
			var oGeneratedFiles = oPSProj.Object.AddFilter(L_strGenerated_Text);
			if (oGeneratedFiles)
			{
				oGeneratedFiles.SourceControlFiles = false;
				oGeneratedFiles.AddFile(str_IFile);
				oGeneratedFiles.AddFile(str_PFile);
				oGeneratedFiles.AddFile(strProjectPath + "\\dlldata.c");
			}
			else
			{
				oPSProj.Object.AddFile(str_IFile);
				oPSProj.Object.AddFile(str_PFile);
				oPSProj.Object.AddFile(strProjectPath + "\\dlldata.c");
			}
			// Set special flags on the MIDL-generated .c file
			var projfile = selProj.Object.Files(strIdlName + "_p.c");
			if (projfile != null) {
				projfile = projfile.Object;
				SetFileProperties(projfile, strIdlName + "_p.c");
			}
			projfile = selProj.Object.Files(strIdlName + "_c.c");
			if (projfile != null) {
				projfile = projfile.Object;
				SetFileProperties(projfile, strIdlName + "_c.c");
			}
			projfile = selProj.Object.Files("dlldata.c");
			if (projfile != null) {
				projfile = projfile.Object;
				SetFileProperties(projfile, "dlldata.c");
			}

			oPSProj.Object.Save();
		}

		// expand main project node, highlight it
		//
		strProjectName	= wizard.FindSymbol("PROJECT_NAME");
		var oHier = wizard.dte.Windows.Item(vsWindowKindSolutionExplorer).Object;
		var oHISolution = oHier.UIHierarchyItems(1);
		var oHIProjMain;
		for (nHI=1; nHI<=oHISolution.UIHierarchyItems.Count; nHI++)
		{
			if ( oHISolution.UIHierarchyItems(nHI).name == strProjectName )
			{
				oHIProjMain = oHISolution.UIHierarchyItems(nHI);
				break;
			}
		}
		if (oHIProjMain)
		{
			oHIProjMain.UIHierarchyItems.Expanded = true;
			oHIProjMain.Select(vsUISelectionTypeSelect);
		}
	}
	catch(e)
	{
		if (e.description.length != 0)
			SetErrorInfo(e);
		return e.number
	}
}

function SetFileProperties(projfile, strName)
{
	if (strName == "dllmain.cpp" || strName.substr(strName.length-2,strName.length) == ".c") {
		var Configs = projfile.Object.FileConfigurations;
		for(var i=1;i<=Configs.Count;++i) {
			var Config = Configs(i);
			var CLTool = Config.Tool;
			CLTool.CompileAsManaged = 0; // Force no /CLR
			CLTool.UsePrecompiledHeader  = 0; // No pre-compiled headers
		}
	}
}

function GetTargetName(strName, strProjectName, strResPath, strHelpPath)
{
	try
	{
		var strTarget = strName;

		if (strName.substr(0, 4) == "root")
		{
			if (strName == "root.idl")
			{
				var strProjectName = wizard.FindSymbol("SAFE_IDL_NAME");
				strTarget = strProjectName + ".idl";
			}
			else if (strName == "root.rc")
			{
				strTarget = wizard.FindSymbol("RC_FILE_NAME");
			}
			else
			{
				strTarget = strProjectName + strName.substr(4);
			}

			return strTarget;
		}

		switch (strName)
		{
			case "readme.txt":
				strTarget = "ReadMe.txt";
				break;
			case "resource.h":
				strTarget = "Resource.h";
				break;
			case "document.cpp":
				strTarget = wizard.FindSymbol("DOCUMENT_IMPL_FILENAME_TRIMMED");
				break;
			case "document.h":
				strTarget = wizard.FindSymbol("DOCUMENT_HEADER_FILENAME_TRIMMED");
				break;
			case "Preview.h":
				strTarget = "PreviewHandler.h";
				break;
			case "Preview.rgs":
				strTarget = "PreviewHandler.rgs";
				break;
			case "Thumbnail.h":
				strTarget = "ThumbnailHandler.h";
				break;
			case "Thumbnail.rgs":
				strTarget = "ThumbnailHandler.rgs";
				break;
			case "Search.h":
				strTarget = "FilterHandler.h";
				break;
			case "Search.rgs":
				strTarget = "FilterHandler.rgs";
				break;
			default:
				break;
		}

		return strTarget;
	}
	catch(e)
	{
		throw e;
	}
}

function SetPSConfigurations(oProj, oMainProj)
{
	try
	{
		oConfigs = oProj.Object.Configurations;
		bSupportComPlus = wizard.FindSymbol("SUPPORT_COMPLUS");

		for (var nCntr = 1; nCntr <= oConfigs.Count; nCntr++)
		{
			var oConfig = oConfigs(nCntr);
			var bDebug = false;
			if (-1 != oConfig.Name.indexOf("Debug"))
				bDebug = true;

			oConfig.IntermediateDirectory = "$(Configuration)PS\\";
			oConfig.ConfigurationType = typeDynamicLibrary;
			oConfig.CharacterSet = charSetUNICODE;
			var oCLTool = oConfig.Tools("VCCLCompilerTool");

			var strDefines = oCLTool.PreprocessorDefinitions;
			if (strDefines != "") strDefines += ";";
			strDefines += GetPlatformDefine(oConfig);
			strDefines += "REGISTER_PROXY_DLL";
			if (bDebug)
			{
				strDefines += ";_DEBUG";
			}
			else
			{
				strDefines += ";NDEBUG";
				oCLTool.Optimization = optimizeMaxSpeed;
			}
			oCLTool.PreprocessorDefinitions = strDefines;

			var oLinkTool = oConfig.Tools("VCLinkerTool");
			oLinkTool.AdditionalDependencies = "kernel32.lib rpcns4.lib rpcrt4.lib oleaut32.lib uuid.lib";

			if (bSupportComPlus)
				oLinkTool.AdditionalDependencies += " ole32.lib advapi32.lib comsvcs.lib";

			oLinkTool.ModuleDefinitionFile = oProj.Name + ".def";

			if (!bDebug)
			{
				oLinkTool.EnableCOMDATFolding = optFolding;
				oLinkTool.OptimizeReferences = optReferences;
			}

			oLinkTool.RegisterOutput = true;

			var oPreBuildTool = oConfig.Tools("VCPreBuildEventTool");
			var strCommand = "if exist dlldata.c goto :END\r\n";
			var L_Echo1_Text = "Echo : MIDL  DLLDATA.CĿ 1 ӿڡ\r\n";
			strCommand += L_Echo1_Text;
			strCommand += "Exit 1\r\n";
			strCommand += ":END\r\n";
			oPreBuildTool.CommandLine = strCommand;
			var L_Echo2_Text = "Ƿļ";
			oPreBuildTool.Description = L_Echo2_Text;
		}

		// exclude from Solution build
		var oSolBuild = dte.Solution.SolutionBuild;
		var oSolConfigs = oSolBuild.SolutionConfigurations;
		for (var nCntr = 1; nCntr <= oSolConfigs.Count; nCntr++)
		{
			var oSolContexts = oSolConfigs(nCntr).SolutionContexts;
			for (var nCntr2 = 1; nCntr2 <= oSolContexts.Count; nCntr2++)
			{
				var oSolContext = oSolContexts(nCntr2);
				if (oSolContext.ProjectName == oProj.UniqueName)
					oSolContext.ShouldBuild = false;
			}
		}

		// add main project to build dependency list
	    oSolBuild.BuildDependencies(oProj.UniqueName).AddProject(oMainProj.UniqueName);
	}
	catch(e)
	{
		throw e;
	}
}

var nNumConfigs = 2;

var astrConfigName = new Array();
astrConfigName[0] = "Debug";
astrConfigName[1] = "Release";

var astrConfigDir = new Array();
astrConfigDir[0] = "Debug";
astrConfigDir[1] = "Release";

var astrDefines = new Array();
astrDefines[0] = "_WINDOWS;_DEBUG";
astrDefines[1] = "_WINDOWS;NDEBUG";

var anCRT = new Array();
anCRT[0] = rtMultiThreadedDebugDLL;
anCRT[1] = rtMultiThreadedDLL;

function AddConfigurations(proj, strProjectName)
{
	try
	{
		var nCntr;
		for (nCntr = 0; nCntr < nNumConfigs; nCntr++)
		{
			var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
			// check if Debug
			var bDebug = false;
			if (-1 != astrConfigName[nCntr].search("Debug"))
				bDebug = true;

			var config = proj.Object.Configurations(astrConfigName[nCntr]);

			// add configuration if it doesn't exist
			if (!config)
			{
				proj.Object.AddConfiguration(astrConfigName[nCntr]);
				config = proj.Object.Configurations(astrConfigName[nCntr]);
			}

			// set configuration type
			var bAppTypeDLL = wizard.FindSymbol("DLL_APP");
			if (bAppTypeDLL)
				config.ConfigurationType = typeDynamicLibrary;

			config.UseOfATL = useATLDynamic;
			config.CharacterSet = charSetUNICODE;

			// Compiler settings
			var CLTool = config.Tools("VCCLCompilerTool");
			CLTool.UsePrecompiledHeader = pchUseUsingSpecific;
			CLTool.WarningLevel = WarningLevel_3;
			if (bDebug)
			{
				CLTool.Optimization = optimizeDisabled;
			}
			else
			{
				CLTool.Optimization = optimizeMaxSpeed;
			}

			var bMFC = wizard.FindSymbol("SUPPORT_MFC");
			var bMergeProxy = wizard.FindSymbol("MERGE_PROXY_STUB");
			var bSupportComPlus	= wizard.FindSymbol("SUPPORT_COMPLUS");
			var bSupportComponentRegistrar = wizard.FindSymbol("SUPPORT_COMPONENT_REGISTRAR");

			var strDefines = CLTool.PreprocessorDefinitions;
			if (strDefines != "") strDefines += ";";
			strDefines += GetPlatformDefine(config);
			strDefines += astrDefines[nCntr];
			if (bAppTypeDLL)
				strDefines += ";_USRDLL";
			if (bMFC)
				config.UseOfMFC = useMfcDynamic;
			if (bMergeProxy && bSupportComponentRegistrar)
				strDefines += ";_MERGE_PROXYSTUB";
			CLTool.PreprocessorDefinitions = strDefines;

			// MIDL settings
			var MidlTool = config.Tools("VCMidlTool");
			MidlTool.MkTypLibCompatible = false;
			if (IsPlatformWin32(config))
				MidlTool.TargetEnvironment = midlTargetWin32;

			if (bDebug)
				MidlTool.PreprocessorDefinitions = "_DEBUG";
			else
				MidlTool.PreprocessorDefinitions = "NDEBUG";

			MidlTool.HeaderFileName = strIdlName + "_i.h";
			MidlTool.InterfaceIdentifierFileName = strIdlName + "_i.c";
			MidlTool.ProxyFileName = strIdlName + "_p.c";
			MidlTool.GenerateStublessProxies = true;
			MidlTool.TypeLibraryName = "$(IntDir)" + strIdlName + ".tlb";
			MidlTool.DLLDataFileName = "";

			// no /no_robust
			MidlTool.ValidateParameters = true;

			// Resource settings
			var RCTool = config.Tools("VCResourceCompilerTool");
			RCTool.Culture = wizard.FindSymbol("LCID");
			RCTool.AdditionalIncludeDirectories = "$(IntDir)";
			if (bDebug)
				RCTool.PreprocessorDefinitions = "_DEBUG";
			else
				RCTool.PreprocessorDefinitions = "NDEBUG";

			// Linker settings
			var LinkTool = config.Tools("VCLinkerTool");
			LinkTool.SubSystem = subSystemWindows;
			LinkTool.IgnoreImportLibrary = true;

			if (bAppTypeDLL)
			{
				var strDefFile = ".\\" + strProjectName + ".def";
				LinkTool.ModuleDefinitionFile = strDefFile;
			}
			if (bSupportComPlus)
				LinkTool.AdditionalDependencies += " comsvcs.lib";

			LinkTool.GenerateDebugInformation = true;
			if (bDebug)
				LinkTool.LinkIncremental = linkIncrementalYes;
			else
			{
				LinkTool.LinkIncremental = linkIncrementalNo;
				LinkTool.EnableCOMDATFolding = optFolding;
				LinkTool.OptimizeReferences = optReferences;
			}


			LinkTool.RegisterOutput = true;

			if (bAppTypeDLL)
			{
				if (wizard.FindSymbol("SEARCH_HANDLER"))
				{
					var PostBuildTool = config.Tools("VCPostBuildEventTool");
					var L_SettingPermissions_Text = "ô DLL Ȩ( SearchFilterHost.exe )...";
					
					var strGroupName = "";
					// Get the localized name of the group "Users" using WMI
					var oWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}");
					var oResultSet = oWMIService.ExecQuery("Select * from Win32_Group Where LocalAccount = TRUE And SID = 'S-1-5-32-545'");
					var resultEnumerator = new Enumerator(oResultSet);
					if (!resultEnumerator.atEnd())
					{
						var oGroup = resultEnumerator.item();
						strGroupName = oGroup.Name;
						PostBuildTool.CommandLine = "cacls.exe \"$(TargetPath)\" /G " + strGroupName + ":r /E";
					}
					else
					{
						var L_SettingPermissionsFailure_Text = "޷ô DLL Ȩ( SearchFilterHost.exe )";
						wizard.ReportError(L_SettingPermissionsFailure_Text);
					}
				}
			}
		}
	}
	catch(e)
	{
		throw e;
	}
}

function SetPchSettings(proj, strProjectName)
{
	try
	{
		var files = proj.Object.Files;
		var fStdafx = files("StdAfx.cpp");

		var nCntr;
		for (nCntr = 0; nCntr < nNumConfigs; nCntr++)
		{
			var config = fStdafx.FileConfigurations(astrConfigName[nCntr]);
			config.Tool.UsePrecompiledHeader = pchCreateUsingSpecific;

			var strIdlName = wizard.FindSymbol("SAFE_IDL_NAME");
			var fProject_i = files(strIdlName + "_i.c");
			config = fProject_i.FileConfigurations(astrConfigName[nCntr]);
			config.Tool.UsePrecompiledHeader = pchNone;

			if (wizard.FindSymbol("MERGE_PROXY_STUB"))
			{
				file = files("xdlldata.c");
				config = file.FileConfigurations(astrConfigName[nCntr]);
				config.Tool.UsePrecompiledHeader = pchNone;
			}
		}
	}
	catch(e)
	{
		throw e;
	}
}

// SIG // Begin signature block
// SIG // MIIaNgYJKoZIhvcNAQcCoIIaJzCCGiMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFOIXw4bPVOU9
// SIG // ulC04mi7/CZpWquGoIIVLTCCBKAwggOIoAMCAQICCmEZ
// SIG // zJMAAQAAAGYwDQYJKoZIhvcNAQEFBQAweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwHhcNMTExMDEwMjAzMjI1WhcN
// SIG // MTMwMTEwMjAzMjI1WjCBgzELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjENMAsGA1UECxMETU9QUjEeMBwGA1UEAxMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEA7lu+fREk44YG4Gb/SLUXvQLk
// SIG // tAwy8HI+fS6H106hsadDL/dlnjHhMjFFrtfBJIQh1y61
// SIG // hH76NdNTHNe2UR5Pzma567cMAv0pXK2oh/bKIrTVvwh1
// SIG // 9Ypwj2PX74oe6Y9DJGRa04d9kG07rHbNVzZ96LwQVqyY
// SIG // 8IldLmTGryYJXh5jFfE9vxaPmYgCwzC3wQtgHw9yzNa3
// SIG // qDUShpuhCwrmk1uO+lScwfMZX0KNEp8dP5C3JxODGTKC
// SIG // HfPZh9QhsjyitgdP1ySq7o31s9n6+TlPp+nyr1lS9NxB
// SIG // my8RcGPd6t6q8W0hBBBTM7uyT8XhU7JBZUduN/a86ZsW
// SIG // QZFrLlswwwIDAQABo4IBHTCCARkwEwYDVR0lBAwwCgYI
// SIG // KwYBBQUHAwMwHQYDVR0OBBYEFBtSDvMRKrfAicMRgT3U
// SIG // lli5o1NuMA4GA1UdDwEB/wQEAwIHgDAfBgNVHSMEGDAW
// SIG // gBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8ETzBN
// SIG // MEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0FfMDgt
// SIG // MzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsG
// SIG // AQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0yMDEw
// SIG // LmNydDANBgkqhkiG9w0BAQUFAAOCAQEApVs2bK1Om2kS
// SIG // 42+KAptpd8NsZHIoiNk9RW0sGHvUKC8T4llqG8ILNLeK
// SIG // /eq5lOwHMeZq9HUE06faXjoGnhD9qQ29nFFDb/9nlJzh
// SIG // z3zwJLA1zINd7trAbzZJwFoKV/Zz4Z7z4whMOz4vzNLN
// SIG // 7k8icPcEHwKmS5u4j1yIDjaUbDMHuKmtUaDQwtyOIhK9
// SIG // w9+C11ah993wpSBXEBCd7qyGdGxxm8Hw8sJwXqfbbU03
// SIG // WJlNeUDQNF1aJa5n6xtORgawjCkfoxCPpTOfI9X4tUZ9
// SIG // 4O5jmJBLPgWoL7AYs1mkr0FTjggFEC0qyToGTBwuqTFR
// SIG // VmSsmsysl5gpipeQh+qdtjCCBLowggOioAMCAQICCmEC
// SIG // jkIAAAAAAB8wDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OFoXDTEz
// SIG // MDQwOTIyMjU1OFowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpGNTI4LTM3NzctOEE3NjElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJbsjkdN
// SIG // VMJclYDXTgs9v5dDw0vjYGcRLwFNDNjRRi8QQN4LpFBS
// SIG // EogLQ3otP+5IbmbHkeYDym7sealqI5vNYp7NaqQ/56ND
// SIG // /2JHobS6RPrfQMGFVH7ooKcsQyObUh8yNfT+mlafjWN3
// SIG // ezCeCjOFchvKSsjMJc3bXREux7CM8Y9DSEcFtXogC+Xz
// SIG // 78G69LPYzTiP+yGqPQpthRfQyueGA8Azg7UlxMxanMTD
// SIG // 2mIlTVMlFGGP+xvg7PdHxoBF5jVTIzZ3yrDdmCs5wHU1
// SIG // D92BTCE9djDFsrBlcylIJ9jC0rCER7t4utV0A97XSxn3
// SIG // U9542ob3YYgmM7RHxqBUiBUrLHUCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBQv6EbIaNNuT7Ig0N6JTvFH7kjB8jAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBz/30unc2NiCt8feNeFXHp
// SIG // aGLwCLZDVsRcSi1o2PlIEZHzEZyF7BLUVKB1qTihWX91
// SIG // 7sb1NNhUpOLQzHyXq5N1MJcHHQRTLDZ/f/FAHgybgOIS
// SIG // CiA6McAHdWfg+jSc7Ij7VxzlWGIgkEUvXUWpyI6zfHJt
// SIG // ECfFS9hvoqgSs201I2f6LNslLbldsR4F50MoPpwFdnfx
// SIG // Jd4FRxlt3kmFodpKSwhGITWodTZMt7MIqt+3K9m+Kmr9
// SIG // 3zUXzD8Mx90Gz06UJGMgCy4krl9DRBJ6XN0326RFs5E6
// SIG // Eld940fGZtPPnEZW9EwHseAMqtX21Tyi4LXU+Bx+BFUQ
// SIG // axj0kc1Rp5VlMIIFvDCCA6SgAwIBAgIKYTMmGgAAAAAA
// SIG // MTANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQB
// SIG // GRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0
// SIG // MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZp
// SIG // Y2F0ZSBBdXRob3JpdHkwHhcNMTAwODMxMjIxOTMyWhcN
// SIG // MjAwODMxMjIyOTMyWjB5MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWduaW5n
// SIG // IFBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBALJyWVwZMGS/HZpgICBCmXZTbD4b1m/My/Hqa/6X
// SIG // FhDg3zp0gxq3L6Ay7P/ewkJOI9VyANs1VwqJyq4gSfTw
// SIG // aKxNS42lvXlLcZtHB9r9Jd+ddYjPqnNEf9eB2/O98jak
// SIG // yVxF3K+tPeAoaJcap6Vyc1bxF5Tk/TWUcqDWdl8ed0WD
// SIG // hTgW0HNbBbpnUo2lsmkv2hkL/pJ0KeJ2L1TdFDBZ+NKN
// SIG // Yv3LyV9GMVC5JxPkQDDPcikQKCLHN049oDI9kM2hOAaF
// SIG // XE5WgigqBTK3S9dPY+fSLWLxRT3nrAgA9kahntFbjCZT
// SIG // 6HqqSvJGzzc8OJ60d1ylF56NyxGPVjzBrAlfA9MCAwEA
// SIG // AaOCAV4wggFaMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
// SIG // BBYEFMsR6MrStBZYAck3LjMWFrlMmgofMAsGA1UdDwQE
// SIG // AwIBhjASBgkrBgEEAYI3FQEEBQIDAQABMCMGCSsGAQQB
// SIG // gjcVAgQWBBT90TFO0yaKleGYYDuoMW+mPLzYLTAZBgkr
// SIG // BgEEAYI3FAIEDB4KAFMAdQBiAEMAQTAfBgNVHSMEGDAW
// SIG // gBQOrIJgQFYnl+UlE/wq4QpTlVnkpDBQBgNVHR8ESTBH
// SIG // MEWgQ6BBhj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2Vy
// SIG // dC5jcmwwVAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAC
// SIG // hjhodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2Nl
// SIG // cnRzL01pY3Jvc29mdFJvb3RDZXJ0LmNydDANBgkqhkiG
// SIG // 9w0BAQUFAAOCAgEAWTk+fyZGr+tvQLEytWrrDi9uqEn3
// SIG // 61917Uw7LddDrQv+y+ktMaMjzHxQmIAhXaw9L0y6oqhW
// SIG // nONwu7i0+Hm1SXL3PupBf8rhDBdpy6WcIC36C1DEVs0t
// SIG // 40rSvHDnqA2iA6VW4LiKS1fylUKc8fPv7uOGHzQ8uFaa
// SIG // 8FMjhSqkghyT4pQHHfLiTviMocroE6WRTsgb0o9ylSpx
// SIG // bZsa+BzwU9ZnzCL/XB3Nooy9J7J5Y1ZEolHN+emjWFbd
// SIG // mwJFRC9f9Nqu1IIybvyklRPk62nnqaIsvsgrEA5ljpnb
// SIG // 9aL6EiYJZTiU8XofSrvR4Vbo0HiWGFzJNRZf3ZMdSY4t
// SIG // vq00RBzuEBUaAF3dNVshzpjHCe6FDoxPbQ4TTj18KUic
// SIG // ctHzbMrB7HCjV5JXfZSNoBtIA1r3z6NnCnSlNu0tLxfI
// SIG // 5nI3EvRvsTxngvlSso0zFmUeDordEN5k9G/ORtTTF+l5
// SIG // xAS00/ss3x+KnqwK+xMnQK3k+eGpf0a7B2BHZWBATrBC
// SIG // 7E7ts3Z52Ao0CW0cgDEf4g5U3eWh++VHEK1kmP9QFi58
// SIG // vwUheuKVQSdpw5OPlcmN2Jshrg1cnPCiroZogwxqLbt2
// SIG // awAdlq3yFnv2FoMkuYjPaqhHMS+a3ONxPdcAfmJH0c6I
// SIG // ybgY+g5yjcGjPa8CQGr/aZuW4hCoELQ3UAjWwz0wggYH
// SIG // MIID76ADAgECAgphFmg0AAAAAAAcMA0GCSqGSIb3DQEB
// SIG // BQUAMF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJ
// SIG // kiaJk/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1p
// SIG // Y3Jvc29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0
// SIG // eTAeFw0wNzA0MDMxMjUzMDlaFw0yMTA0MDMxMzAzMDla
// SIG // MHcxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xITAfBgNVBAMTGE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFBDQTCCASIwDQYJKoZI
// SIG // hvcNAQEBBQADggEPADCCAQoCggEBAJ+hbLHf20iSKnxr
// SIG // LhnhveLjxZlRI1Ctzt0YTiQP7tGn0UytdDAgEesH1VSV
// SIG // FUmUG0KSrphcMCbaAGvoe73siQcP9w4EmPCJzB/LMySH
// SIG // nfL0Zxws/HvniB3q506jocEjU8qN+kXPCdBer9CwQgSi
// SIG // +aZsk2fXKNxGU7CG0OUoRi4nrIZPVVIM5AMs+2qQkDBu
// SIG // h/NZMJ36ftaXs+ghl3740hPzCLdTbVK0RZCfSABKR2YR
// SIG // JylmqJfk0waBSqL5hKcRRxQJgp+E7VV4/gGaHVAIhQAQ
// SIG // MEbtt94jRrvELVSfrx54QTF3zJvfO4OToWECtR0Nsfz3
// SIG // m7IBziJLVP/5BcPCIAsCAwEAAaOCAaswggGnMA8GA1Ud
// SIG // EwEB/wQFMAMBAf8wHQYDVR0OBBYEFCM0+NlSRnAK7UD7
// SIG // dvuzK7DDNbMPMAsGA1UdDwQEAwIBhjAQBgkrBgEEAYI3
// SIG // FQEEAwIBADCBmAYDVR0jBIGQMIGNgBQOrIJgQFYnl+Ul
// SIG // E/wq4QpTlVnkpKFjpGEwXzETMBEGCgmSJomT8ixkARkW
// SIG // A2NvbTEZMBcGCgmSJomT8ixkARkWCW1pY3Jvc29mdDEt
// SIG // MCsGA1UEAxMkTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNh
// SIG // dGUgQXV0aG9yaXR5ghB5rRahSqClrUxzWPQHEy5lMFAG
// SIG // A1UdHwRJMEcwRaBDoEGGP2h0dHA6Ly9jcmwubWljcm9z
// SIG // b2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL21pY3Jvc29m
// SIG // dHJvb3RjZXJ0LmNybDBUBggrBgEFBQcBAQRIMEYwRAYI
// SIG // KwYBBQUHMAKGOGh0dHA6Ly93d3cubWljcm9zb2Z0LmNv
// SIG // bS9wa2kvY2VydHMvTWljcm9zb2Z0Um9vdENlcnQuY3J0
// SIG // MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0GCSqGSIb3DQEB
// SIG // BQUAA4ICAQAQl4rDXANENt3ptK132855UU0BsS50cVtt
// SIG // DBOrzr57j7gu1BKijG1iuFcCy04gE1CZ3XpA4le7r1ia
// SIG // HOEdAYasu3jyi9DsOwHu4r6PCgXIjUji8FMV3U+rkuTn
// SIG // jWrVgMHmlPIGL4UD6ZEqJCJw+/b85HiZLg33B+JwvBhO
// SIG // nY5rCnKVuKE5nGctxVEO6mJcPxaYiyA/4gcaMvnMMUp2
// SIG // MT0rcgvI6nA9/4UKE9/CCmGO8Ne4F+tOi3/FNSteo7/r
// SIG // vH0LQnvUU3Ih7jDKu3hlXFsBFwoUDtLaFJj1PLlmWLMt
// SIG // L+f5hYbMUVbonXCUbKw5TNT2eb+qGHpiKe+imyk0Bnca
// SIG // Ysk9Hm0fgvALxyy7z0Oz5fnsfbXjpKh0NbhOxXEjEiZ2
// SIG // CzxSjHFaRkMUvLOzsE1nyJ9C/4B5IYCeFTBm6EISXhrI
// SIG // niIh0EPpK+m79EjMLNTYMoBMJipIJF9a6lbvpt6Znco6
// SIG // b72BJ3QGEe52Ib+bgsEnVLaxaj2JoXZhtG6hE6a/qkfw
// SIG // Em/9ijJssv7fUciMI8lmvZ0dhxJkAj0tr1mPuOQh5bWw
// SIG // ymO0eFQF1EEuUKyUsKV4q7OglnUa2ZKHE3UiLzKoCG6g
// SIG // W4wlv6DvhMoh1useT8ma7kng9wFlb4kLfchpyOZu6qeX
// SIG // zjEp/w7FW1zYTRuh2Povnj8uVRZryROj/TGCBHUwggRx
// SIG // AgEBMIGHMHkxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xIzAhBgNV
// SIG // BAMTGk1pY3Jvc29mdCBDb2RlIFNpZ25pbmcgUENBAgph
// SIG // GcyTAAEAAABmMAkGBSsOAwIaBQCggaAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFIn4
// SIG // dYTZSAiDQ3ouQrlDjrZDhVaaMEAGCisGAQQBgjcCAQwx
// SIG // MjAwoBaAFABkAGUAZgBhAHUAbAB0AC4AagBzoRaAFGh0
// SIG // dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAMvdMmkF+MSTJnv6VPSBiPg8pcvdpB7IVR0g/G2S
// SIG // zF4hCQwVlv0fbFPTWWXgwFPUJUx5xgmn6ltmLYyN+gfS
// SIG // p/mkhxMdrjq8zNbKWgVm+Y41pPPmuWEVO+9G+ififNxE
// SIG // 0U+Fwsvb+EwlL05ijezOSxB0WCqLdanwMr6A45MM16ba
// SIG // WG5mjp8QZvrUnBmXXYg+pQN5D188A2eHm4wvECvCURD/
// SIG // frNF7ddTulfmEC4YKigkfR71JHDNaY06w9u3+cuVbDP5
// SIG // RcBVV3mvD/I+CeYwwU4UO6al4M7BHtbl4Je3eU0LIi/a
// SIG // dCvBXjpcqRUm0q8RSHo2zr0m9Jcf0q1FgJg+PW2hggIf
// SIG // MIICGwYJKoZIhvcNAQkGMYICDDCCAggCAQEwgYUwdzEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgUENBAgphAo5CAAAAAAAfMAkG
// SIG // BSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcN
// SIG // AQcBMBwGCSqGSIb3DQEJBTEPFw0xMjA3MjcwMzM5MTRa
// SIG // MCMGCSqGSIb3DQEJBDEWBBSHZXljbp06+cnUtbqN04rx
// SIG // H5jfGDANBgkqhkiG9w0BAQUFAASCAQAxzO5eP5OXyBXS
// SIG // PnewOhstZ6cR+VSui3teD/aTzTbIkObWtw+29Pfqi9cA
// SIG // W2O1cCrJqpKNM46vWQp7zQjg4lcK2BhxViZ4PzWU3nnt
// SIG // pQP+/cya1n3ypvpx6oU7TnJAEjSERfujRbVaEJatoIO6
// SIG // Sr1RCX9EzR1NH7p0bbW980yDSZWgJRM0Wr2s96ofpn7/
// SIG // U7Oa0UXxNOkH+B3SrHVrHr4uPRV7iIvOOUevrC8nC8gf
// SIG // DQO3hhF1M6GnQqzpGjYymENKBNadPQ2HK1sN9rkbyCeZ
// SIG // 2IIrdb/xwEfpiNHmCMf2F2V+I8sbYYLoDj3ce0FcYEso
// SIG // vWZ2qhW0i5HYgD57BSxF
// SIG // End signature block
